#!/usr/bin/env php
<?php

$rootDir = dirname(__DIR__, 2);
$mainDir = sprintf('%s/main', $rootDir);
$outputFile = sprintf('%s/debug_gdb_scripts.c', $mainDir);

printf("Generating %s\n", $outputFile);

$gdbscript = file_get_contents(sprintf("%s/.gdbinit", $rootDir));
$pyscript = file_get_contents(sprintf("%s/php_gdb.py", __DIR__));

// We can not inline .gdbinit, but we can embed it in the python script.
$pyscript = sprintf(
    "gdb.execute('''\n%s\n''')\n%s",
    addcslashes($gdbscript, '\'\\'),
    $pyscript,
);

$ccode = sprintf(
    <<<'C'
    /*
     * Generated by %s.
     *
     * This inlines .gdbinit and php_gdb.py into the .debug_gdb_scripts
     * section of the binary, so that they can be found by gdb.
     *
     * See https://sourceware.org/gdb/current/onlinedocs/gdb.html/dotdebug_005fgdb_005fscripts-section.html#dotdebug_005fgdb_005fscripts-section
     */
    asm(
        ".pushsection \".debug_gdb_scripts\", \"MS\",%%progbits,1\n"
        ".byte 4 /* Python Text */\n"
        ".ascii \"gdb.inlined-script\\n\"\n"
        %s
        ".byte 0\n"
        ".popsection\n"
    );

    C,
    basename(__FILE__),
    implode("\n    ", array_map(function ($line) {
        $escapedPy = addcslashes($line."\n", "\"\n\\");
        $escapedAsm = addcslashes(sprintf(".ascii \"%s\"\n", $escapedPy), "\"\n\\?");
        return sprintf('"%s"', $escapedAsm);
    }, explode("\n", $pyscript))),
);

$len = file_put_contents($outputFile, $ccode);

if ($len !== strlen($ccode)) {
    printf("Failed\n");
    exit(1);
}
