// Please see the README file or the LEGAL NOTES-section in the manual before modifying, compiling or using 'xmrm'
//   Idea: Manfred Kopp
//   Programming: Gerhard Waldhr, Andreas Artmann

#include <stdlib.h>
#include <forms.h>
#include "init.h"
#include "const.h"
#include "io.h"

extern ControlClass control;
extern Display *disp;

void GetMaskValues(int *beg, int *len, unsigned long mask)
{
  *beg=0; *len=0;

  if (mask != 0)
  {
    while (!(mask & 1)) { (*beg)++; mask = mask>>1; }
    while (mask & 1) { (*len)++; mask = mask>>1; }
  }
}

/* VisualInfoClass: */

void VisualInfoClass::GetVisualInfo()
{
  int r,g,b;
  unsigned long mask;

  // Getting visual info
  XVisualInfo xvis_temp; int n_items;
  xvis_info = (XVisualInfo *)malloc(1*sizeof(XVisualInfo));
  if ( (xvis_info = XGetVisualInfo(disp,VisualNoMask,&xvis_temp,&n_items)) == NULL )
  {
    printf("Fatal error: No Visual Information matched !\n");
    exit(1);
  }
  // Getting display color depth:
  depth = xvis_info->depth;
  if (depth==24) p_fetch=32; // internal 32bit fetch for 24bpp mode
  else if (depth==15) p_fetch=16; // internal 16bit fetch for 15bpp mode
  else p_fetch=depth;
  
  if (xvis_info->red_mask)
  {
    GetMaskValues(&red_beg,&red_len,xvis_info->red_mask);
    GetMaskValues(&green_beg,&green_len,xvis_info->green_mask);
    GetMaskValues(&blue_beg,&blue_len,xvis_info->blue_mask);    

    if (control.debug)
    {
      printf("DISPLAY %dbpp R_MASK:%X G_MASK:%X B_MASK:%X\n\n",
             depth,xvis_info->red_mask,xvis_info->green_mask,xvis_info->blue_mask);
    }
  }
  else
  {
    printf("\n");
    printf("Error: No DirectColor (RealColor or TrueColor) mode detected !\n");
    printf("       Please try to install a DirectColor mode at your X-Server\n");
    printf("       or use another graphic device !\n\n");
    exit(-1);
  }
}  

/* WindowClass: */

Window WindowClass::GetWin()
{
  return win;
}

/*
GC WindowClass::GetGC()
{
  return gc;
}
*/
void WindowClass::SetWin()
{
  win = fl_winget();
}
/*
void WindowClass::SetGC()
{
  gc = fl_state[fl_get_vclass()].gc[0];
}
*/
