#include "demogra1.h"
#include <stdlib.h>

using namespace std;

// #define DEBUG
#define AKLASSEN 100

demographie::demographie(char* filename)
{	
    int jahr;
    int i;
    ifstream file(filename);
    if (!file){
	cerr << "error: (demographie): can not open inputfile: " 
		<< filename << endl;
	exit(2);
    }
    flag = 0.0;
    gm=1.02;
    gf=1.0;
    f=new float[AKLASSEN];
    m=new float[AKLASSEN];
    f0=new float[AKLASSEN];
    m0=new float[AKLASSEN];
    sf=new float[AKLASSEN];
    sm=new float[AKLASSEN];
    migf=new float[AKLASSEN];
    migm=new float[AKLASSEN];
    migf0=new float[AKLASSEN];
    migm0=new float[AKLASSEN];
    verteilung_im=new float[AKLASSEN];
    verteilung_if=new float[AKLASSEN];
    verteilung_em=new float[AKLASSEN];
    verteilung_ef=new float[AKLASSEN];
    if(f==NULL || m==NULL || sf==NULL || sm==NULL || migf==NULL || 
       migm==NULL || migf0==NULL || verteilung_if == NULL ||  
       verteilung_ef == NULL || migm0==NULL || m0==NULL || f0==NULL){
	cerr << "error (demographie): could not allocate memory" << endl;
	exit(2);
    }
    for(i=0; i<AKLASSEN;i++)
	f[i]=m[i]=f0[i]=m0[i]=sf[i]=sm[i]=verteilung_im[i]=verteilung_if[i]=
	verteilung_em[i]=verteilung_ef[i]=migf[i]=migm[0]=migf0[i]=migm0[i]=0.0;
    // read in
    i=0;
    char ch;
    char buf[256];
    file.getline(buf,255);
    for(i=0; i<AKLASSEN;i++){
	file >> jahr>>ch>> f[i] >>ch>> m[i] >>ch>> sf[i] 
		>>ch>> sm[i] >> ch >> verteilung_if[i] >> ch >> verteilung_im[i]
		>>ch>>verteilung_ef[i]>>ch>>verteilung_em[i];
	// cerr << verteilung_if[i] << " " << verteilung_im[i] << endl;
    }	
    file.close();

    sf[99]=sm[99]=0.75;
    verteilung_if[99]=verteilung_ef[99]=verteilung_im[99]=verteilung_em[99]=0.0;
    // copy to original
    for(i=0; i<AKLASSEN; i++){
	f0[i]=f[i];
	m0[i]=m[i];
	migf0[i]=0.0;
	migm0[i]=0.0;
    }
}

demographie::~demographie()
{
   
}

void demographie::reset()
{
    for(int i=0; i<AKLASSEN; i++){
	f[i]=f0[i];
	m[i]=m0[i];
	migf[i]=migf0[i];
	migm[i]=migm0[i];
    }
}

void demographie::step()
{
    float dm, df;
    dm=df=0.0;

    for(int i=15; i<45; i++){ // Ermittlung der Frauen im gebaehrfaehigen Alter
	df+=f[i];
    }
    dm=df;

    dm*=gm/30.0; // Anzahl der geb. Jungen 
    df*=gf/30.0; // Anzahl der geb. Maedchen
    

    // sterben und abwandern
    for(int i=0; i<AKLASSEN; i++){
	m[i]*=(1.0-sm[i]);
	f[i]*=(1.0-sf[i]);
	m[i]+=migm[i];
	f[i]+=migf[i];
	if(f[i]<0)f[i]=0.0;
	if(m[i]<0)m[i]=0.0;
    }

    // Aufruecken der Menschen in die naechste Altersklasse 
    for(int i=AKLASSEN-1; i>=1; i--){
	m[i]=m[i-1];
	f[i]=f[i-1];
    }

    // Zunahme der Kinder im ersten Lebensjahr
    m[0]=dm; 
    f[0]=df; 


#ifdef DEBUG
    cerr << "dm: " << dm << " df: " << df << " gm: " << gm << " gf: " << gf << endl;
#endif
} 

void demographie::save(char* filename)
{
    ofstream file(filename);
    for(int i=0; i<AKLASSEN; i++)
	file << i << " " << m[i] << " " << f[i] << endl;
    file.close();
}

void demographie::gebset(float geb)
{
    gf=geb/2.0;
    gm=1.05*gf;
}

void demographie::mig_plus(float inp)
{
    float sum=0;
    for(int i=0; i<AKLASSEN; i++){
	sum+=verteilung_if[i]+verteilung_im[i];
    }
   // cerr << "mig_plus: " << inp << endl;
    for(int i=0; i<AKLASSEN; i++){
	migf0[i]=(inp*verteilung_if[i])/sum;
	migm0[i]=(inp*verteilung_im[i])/sum;
	migf[i]=migf0[i];
	migm[i]=migm0[i];
    }
}

void demographie::mig_minus(float inp)
{
    float sum=0;
    for(int i=0; i<AKLASSEN; i++){
	sum+=verteilung_ef[i]+verteilung_em[i];
    }
    for(int i=0; i<AKLASSEN; i++){
	migf0[i]+=(inp*verteilung_ef[i])/sum;
	migm0[i]+=(inp*verteilung_em[i])/sum; 
	migf[i]=migf0[i];
	migm[i]=migm0[i];
	// cerr << migf[i] << " " << migm[i] << endl;
    }
}

float demographie::get_m()
{
    float sum=0;
    for(int i=0; i<AKLASSEN; i++)
	sum+=m[i];
    return sum;
}

float demographie::get_f()
{
    float sum=0;
    for(int i=0; i<AKLASSEN; i++)
	sum+=f[i];
    return sum;
}
